/*======================================================================*/
/*                TITLE:          TGA.H                                 */
/*                Function:       TGA defines and structures            */
/*                                                                      */
/*                First Edit:     04/22/93                              */
/*                Programmer:     Andrew J. Burgess                     */
/*                                                                      */
/*                 COPYRIGHT 1993 ATARI GAMES CORP.                     */
/*       UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,            */
/*       PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR             */
/*     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.          */
/*                         ALL RIGHTS RESERVED.                         */
/*                                                                      */
/*----------------------------------------------------------------------*/


/*======================================================================*/
/*                        DEFINES                                       */
/*======================================================================*/

#define	DATA16		(U8)16	/* 16-bit data type			*/
#define	DATA24		(U8)24	/* 24-bit data type			*/

#define	CRY_FMT		1	/* CRY image output			*/
#define	RGB_FMT		2	/* RGB image output			*/

/*======================================================================*/
/*	MACROS								*/
/*======================================================================*/

/*======================================================================*/
/*	DATA TYPES							*/
/*======================================================================*/

/* TGA HEADER BLOCK	*/
typedef struct hdr
{
	U16	nameSize;	/* number of bytes in name string	*/
	U8	unused1[ 10 ];	/* unknown data and unsed for us	*/
	U16	imageWidth;	/* bit-mapped image width		*/
	U16	imageHeight;	/* bit-mapped image height		*/
	U8	bitsPerPixel;	/* 24-bit or 16-bit data type		*/
	U8	unused2;
} TGAHDR;

typedef struct bswap
{
	U8	loByte;
	U8	hiByte;
} BYTESWAP;

typedef struct wswap
{
	U8	loWord;
	U8	hiWord;
} WORDSWAP;

/*======================================================================*/
/*	                             EOF                                */
/*======================================================================*/

